;**************************************
; Test LCD
; Hardware  : ET-BASE 16F628 V1
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 7/02/2005
;**************************************
;       PIC16F628  pin                          LCD pin
;        RA0           ->                                  D0
;        RA1           ->                                  D1
;        RA2           ->                                  D2
;        RA3           ->                                  D3
;        RA4           ->                                 EN
;        RA6           ->                                 RS

     list p=16f628A                         ; list directive to define processor
     #include <p16f628A.inc>        ; processor specific variable definitions

#define   RS        PORTA,6        ; RS pin
#define   E         PORTA,4        ; Enable pin

com       EQU       0x20           ; buffer for Instruction
dat       EQU       0x21           ; buffer for data
count1    EQU       0x22
count2    EQU       0x23
count3    EQU       0x24
offset    EQU       0x25


          ORG       0x0000

;************ initial *******************

init      call      delay
          call      delay
          call 		delay		   ; wait for startup LCD	

		  movlw     0x07           ;Turn comparators off and
 	      movwf     CMCON          ;enable pins for I/O functions
                                  
          bsf       STATUS,RP0     ; select bank 1
          clrf      TRISA          ; All port A is output
          bcf       STATUS,RP0     ; select bank 0

          movlw     B'00110011'    ; 
          call      WR_INS
          movlw     B'00110010'
          call      WR_INS
          movlw     B'00101000'    ; 4 bits, 2 lines,5X7 dot 
          call      WR_INS
          movlw     B'00001100'    ; display on/off
          call      WR_INS
          movlw     B'00000110'    ; Entry mode
          call      WR_INS
          movlw     B'00000001'    ; Clear ram
          call      WR_INS
          movlw     B'00000001'    ; Clear ram
          call      WR_INS

          clrf      offset         ; load offset of character table
start     movf      offset,w       
          call      TAB
          addlw     0              ; Character = 00 ?
          btfsc     STATUS,Z       ; Character = 00 ?
          goto      endmass        ; Yes , Z = 1
                                   ; No  , Z = 0
 		  call      WR_DATA
          incf      offset,f       ; TXREG empty  or TRMT = 1
          goto      start          ; Send again

endmass   nop
          goto      endmass        ; end program 

;********* Tebel of message ********************  
TAB       addwf     PCL,F            ; Move offset to PC lower
          
	  DT   "ET-BASE 16F628",0X0


;****************************************
; Write command to LCD
; Input  : W
; output : -
;****************************************
WR_INS    bcf       RS        ; clear RS
          movwf     com       ; W --> com
          swapf     com,w
          andlw     0x0F      ; mask 4 bits MSB  W = X0
          iorlw     B'00010000' ; Hold En state
          movwf     PORTA     ; Send 4 bits MSB
          bcf       E         ; 
          call      delay     ; __    __      
          bsf       E         ;   |__|
          movf      com,w
          andlw     0x0F      ; 
          iorlw     B'00010000' ; Hold En state
          movwf     PORTA     ; send 4 bits LSB
          bcf       E         ;
          call      delay     ; __    __      
          bsf       E         ;   |__|
          call      delay
          return

;***************************************
; Write data to LCD
; Input  : W
; Output : -
;***************************************
WR_DATA   bsf       RS
          movwf     dat
          swapf     dat,w
          andlw     0x0F      ; mask 4 bits MSB  W = X0
          iorlw     B'01010000' ; Hold RS state
          movwf     PORTA     ; Send 4 bits MSB
          bcf       E         
          call      delay     ; __    __
          bsf       E         ;   |__|
          movf      dat,w
          andlw     0x0F
          iorlw     B'01010000' ; Hold RS state
          movwf     PORTA
          bcf       E         ; 
          call      delay     ; __    __
          bsf       E         ;   |__|
          return

;***************************************
; Delay 
;***************************************
delay     movlw     5
          movwf     count1
del1      clrf      count2
del2      decfsz    count2
          goto      del2
          decfsz    count1
          goto      del1
          return

          END
